<?php
include_once '../baseInfo.php';
include_once '../config.php';

$now   = time();
$limit = 500;
$oneDay = 86400; // ۲۴ ساعت به ثانیه

@unlink('warnOffset.txt');

/* -------------------- Helpers -------------------- */
function normalizeTs($ts) {
    if ($ts === null || $ts === '') return null;
    if (is_numeric($ts)) {
        $ts = (int)$ts;
        if ($ts > 2000000000) $ts = intdiv($ts, 1000); // ms->s
        return $ts > 0 ? $ts : null;
    }
    $t = strtotime((string)$ts);
    return $t ? $t : null;
}

function safeName($s) {
    $s = trim((string)$s);
    $s = preg_replace('/[\x00-\x1F\x7F]/u', '', $s);
    $s = preg_replace('/\s+/u', ' ', $s);
    return $s;
}

/* -------------------- LOOP 1: بررسی وضعیت و ارسال هشدار -------------------- */
$stmt = $connection->prepare("
    SELECT * FROM `orders_list`
    WHERE `status`=1 AND `notif`=0
    ORDER BY id ASC
    LIMIT ?
");
$stmt->bind_param("i", $limit);
$stmt->execute();
$orders = $stmt->get_result();
$stmt->close();

if ($orders && $orders->num_rows > 0) {
    while ($order = $orders->fetch_assoc()) {
        $orderId    = (int)$order['id'];
        $from_id    = $order['userid'];
        $remark     = $order['remark'] ?? '';
        $uuid       = $order['uuid'] ?? "0";
        $server_id  = (int)$order['server_id'];
        $inbound_id = (int)$order['inbound_id'];

        $expiryFromDb = !empty($order['expire_date']) ? $order['expire_date'] : ($order['expire_time'] ?? null);
        $expiryDbSec  = normalizeTs($expiryFromDb);

        $found=false; $enable=true; $expiryPanel=null; $total=null; $up=0; $down=0;
        $matchedEmail = '';

        // دریافت نوع سرور
        $stmt = $connection->prepare("SELECT `type` FROM `server_config` WHERE `id`=?");
        $stmt->bind_param('i', $server_id);
        $stmt->execute();
        $serverType = ($stmt->get_result()->fetch_assoc())['type'] ?? '';
        $stmt->close();

        // استخراج اطلاعات از پنل (Marzban یا X-UI)
        if ($serverType === "marzban") {
            $info = getMarzbanUser($server_id, $remark);
            if (isset($info->username)) {
                $found = true;
                $total = isset($info->data_limit) ? (int)$info->data_limit : null;
                $up    = isset($info->used_traffic) ? (int)$info->used_traffic : 0;
                $expiryPanel = $info->expire ?? null;
                $enable = (($info->status ?? '') === 'active');
            }
        } else {
            $response = getJson($server_id);
            if ($response && $response->success) {
                foreach ($response->obj as $row) {
                    $settings = json_decode($row->settings ?? '{}', true);
                    $clients = $settings['clients'] ?? [];
                    foreach ($clients as $c) {
                        if (($c['id'] ?? '') == $uuid || ($c['password'] ?? '') == $uuid) {
                            $found = true;
                            $email = $c['email'] ?? '';
                            $matchedEmail = $email;
                            
                            // متغیرهای ترافیک بر اساس مدل پنل شما (Inbound یا ClientStats)
                            if ($inbound_id > 0) {
                                foreach ($row->clientStats as $st) {
                                    if ($st->email == $email) {
                                        $up = $st->up; $down = $st->down;
                                        $expiryPanel = $st->expiryTime;
                                        $enable = $st->enable;
                                        break;
                                    }
                                }
                            } else {
                                $up = $row->up; $down = $row->down;
                                $expiryPanel = $row->expiryTime;
                                $enable = $row->enable;
                            }
                            $total = $c['totalGB'] ?? ($row->total ?? null);
                            break 2;
                        }
                    }
                }
            }
        }

        $displayName = safeName(!empty($remark) ? $remark : (!empty($matchedEmail) ? $matchedEmail : $uuid));
        $expiryAnySec = normalizeTs($expiryPanel) ?? $expiryDbSec;
        
        $leftgb = null;
        if ($found && $total !== null) {
            $leftgb = round((max(0, (int)$total - ($up + $down))) / 1073741824, 2);
        }

        // ۱. بررسی اتمام سرویس (همین الان تمام شده) -> حذف ۲۴ ساعت بعد
        $isFinished = false;
        if ($leftgb !== null && $leftgb <= 0) $isFinished = true;
        if ($expiryAnySec !== null && $expiryAnySec <= $now) $isFinished = true;
        if ($found && !$enable) $isFinished = true;

        if ($isFinished) {
            $deleteTime = $now + $oneDay; 
            $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `id`=?");
            $stmt->bind_param("ii", $deleteTime, $orderId);
            $stmt->execute();
            $stmt->close();

            $msg = "🚫 اشتراک «{$displayName}» به پایان رسید.\nاین سرویس جهت امکان تمدید، تا ۲۴ ساعت آینده در لیست شما باقی می‌ماند و سپس حذف می‌شود.";
            sendMessage($msg, null, null, $from_id);
            continue;
        }

        // ۲. بررسی هشدار (کمتر از ۱ روز یا ۱ گیگ مانده) -> حذف ۴۸ ساعت بعد (یک روز هشدار + یک روز مهلت)
        $shouldWarnTime = ($expiryAnySec !== null && $expiryAnySec < ($now + $oneDay));
        $shouldWarnData = ($leftgb !== null && $leftgb < 1);

        if ($shouldWarnTime || $shouldWarnData) {
            $deleteTime = $now + ($oneDay * 2); 
            $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `id`=?");
            $stmt->bind_param("ii", $deleteTime, $orderId);
            $stmt->execute();
            $stmt->close();

            $unit = $shouldWarnTime ? "کمتر از ۱ روز" : "کمتر از ۱ گیگابایت";
            $msg = "⚠️ هشدار: از سرویس «{$displayName}» تنها {$unit} باقی مانده است.\nلطفاً برای جلوگیری از قطع سرویس، آن را تمدید کنید.";
            sendMessage($msg, null, null, $from_id);
            continue;
        }
    }
}

/* -------------------- LOOP 2: حذف نهایی (زمان Notif رسیده است) -------------------- */
$stmt = $connection->prepare("
    SELECT * FROM `orders_list`
    WHERE `status`=1 AND `notif` > 0 AND `notif` < ?
    LIMIT 200
");
$stmt->bind_param("i", $now);
$stmt->execute();
$orders = $stmt->get_result();
$stmt->close();

if ($orders && $orders->num_rows > 0) {
    while ($order = $orders->fetch_assoc()) {
        $orderId    = (int)$order['id'];
        $from_id    = $order['userid'];
        $uuid       = $order['uuid'] ?? "0";
        $server_id  = (int)$order['server_id'];
        $inbound_id = (int)$order['inbound_id'];
        $displayName = safeName($order['remark'] ?? $uuid);

        $stmt = $connection->prepare("SELECT `type` FROM `server_config` WHERE `id`=?");
        $stmt->bind_param('i', $server_id);
        $stmt->execute();
        $serverType = ($stmt->get_result()->fetch_assoc())['type'] ?? '';
        $stmt->close();

        // حذف از پنل
        if ($serverType === "marzban") {
            $res = deleteMarzban($server_id, $order['remark'] ?? '');
        } else {
            $res = ($inbound_id > 0) ? deleteClient($server_id, $inbound_id, $uuid, 1) : deleteInbound($server_id, $uuid, 1);
        }

        // حذف نهایی از دیتابیس بر بستر UUID
        if (!is_null($res)) {
            $stmt = $connection->prepare("DELETE FROM `orders_list` WHERE `uuid`=?");
            $stmt->bind_param("s", $uuid);
            $stmt->execute();
            $stmt->close();

            $msg = "🗑 اشتراک «{$displayName}» به دلیل پایان مهلت استفاده حذف گردید.";
            sendMessage($msg, null, null, $from_id);
        } else {
            // اگر خطایی در حذف از پنل بود، ۶ ساعت دیگر مجدد تلاش کن
            $retry = $now + 21600;
            $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `id`=?");
            $stmt->bind_param("ii", $retry, $orderId);
            $stmt->execute();
            $stmt->close();
        }
    }
}